#ifndef LINUX_SKBUFF_H_BACKPORT
#define LINUX_SKBUFF_H_BACKPORT

#include_next <linux/skbuff.h>

#define CHECKSUM_PARTIAL CHECKSUM_HW 
#define CHECKSUM_COMPLETE CHECKSUM_HW 

#define gso_size tso_size

static inline u16 __skb_checksum_complete(struct sk_buff *skb)
{
        return csum_fold(skb_checksum(skb, 0, skb->len, skb->csum));
}

#define skb_queue_reverse_walk(queue, skb) \
        for (skb = (queue)->prev; \
                prefetch(skb->prev), (skb != (struct sk_buff *)(queue)); \
                skb = skb->prev)

#endif
